#include <SoftwareSerial.h>

SoftwareSerial acceleratorSerial( 7, 8); // RX, TX

int pinButton1 = 8;
int powerRelayPin = 2; // ECM Power3
int faultRelayPin = 3; // Sensor Power
int LEDpin = 13;

int stateButton1;
int stateButton2;
int previous = LOW;


unsigned long time = 0;
unsigned long qtime = 0;
unsigned long currentMillis=0;

unsigned long displayTime = 0;
unsigned long startTime = 0;
unsigned long testDuration = 25000;

unsigned long VSSfreqChangeTime = 10;
unsigned long speedChangeStartTime = 15000; //Milliseconds after start time.
unsigned long powerLossStartTime = 34000;
unsigned long powerLossDuration = 100;
unsigned long lastSensorChangeTime =0;

unsigned long SensorFreqChangeTime = 10;
unsigned long sensorChangeStartTime=4000;
unsigned long faultRelayPinStartTime = 16000;
unsigned long faultRelayPinDuration = 20000;

boolean testStarted = false;
boolean powerOff = false;
boolean faultRelayPinOn = false;
boolean sensorState = false;

int simulatedVSSpin= 5;
int originalVSSfreq=400;
int VSSfreq = 400;
int VSSfreqChangeStep = 5;
int VSStimeChangeStep = 5; //ms

//int simulatedSensorPin=7;
int originalSensorFreq=50;
int SensorFreq = 50;
int SensorFreqChangeStep = 5;
int SensorTimeChangeStep = 10; //ms


int modAmp = 50; 
float modFreq = 0.2;

int accelPedalPeriod = 10; //ms
int originalPedalPeriod = 20;
int pedalAmp = 10;
float pedFreq = 2.5;
  
byte appByte = 20;

void setup() {
  Serial.begin(115200);
  Serial.println("University of Tulsa");
  Serial.println("Engine Control Module (ECM) Power Loss Testing");
  Serial.println("Test parameters are as follows:");
  Serial.print("Speed Change Start Time:\t");
  Serial.print(speedChangeStartTime);
  Serial.println("\tmilliseconds");
  Serial.print("Power Loss Start Time:\t");
  Serial.print(powerLossStartTime);
  Serial.println("\tmilliseconds");
  Serial.print("Test Duration:\t");
  Serial.print(testDuration);
  Serial.println("\tmilliseconds");
  Serial.print("faultRelayPinStartTime:\t");
  Serial.print(faultRelayPinStartTime);
  Serial.println("\tmilliseconds");
  Serial.print("faultRelayPinDuration:\t");
  Serial.print(faultRelayPinDuration);
  Serial.println("\tmilliseconds");
  Serial.print("Starting VSSfrequency:\t");
  Serial.print(originalVSSfreq);
  Serial.println("\tHz");
  Serial.print("VSStimeChangeStep:\t");
  Serial.print(VSStimeChangeStep);
  Serial.println("\tmilliseconds");
  Serial.print("VSSfreqChangeStep:\t");
  Serial.print(VSSfreqChangeStep);
  Serial.println("\tHz");
 
  pinMode(pinButton1, INPUT);
  pinMode(powerRelayPin, OUTPUT);
  pinMode(faultRelayPin, OUTPUT);
  pinMode(simulatedVSSpin, OUTPUT);
  //pinMode(simulatedSensorPin, OUTPUT);
  pinMode(LEDpin, OUTPUT);

// Starting conditions
  currentMillis = millis();
  tone(simulatedVSSpin,VSSfreq);
  
  digitalWrite(powerRelayPin, powerOff);
  digitalWrite(faultRelayPin, faultRelayPinOn);
  
  Serial.println("Time [ms]\tVSSfreq. [Hz]\tSensorFreq\tpowerRelayPin [1=on,0=off]\tfaultRelayPin [1=on,0=off]");
    
  acceleratorSerial.begin(115200);
}
 
void loop() {
  currentMillis = millis();
  digitalWrite(LEDpin,testStarted);
  
  
  //Start the test
  stateButton1 = digitalRead(pinButton1);
  if(stateButton1 == HIGH && testStarted == false) {
    testStarted = true;
    startTime = currentMillis;
     pinMode(simulatedVSSpin,OUTPUT);
    //pinMode(simulatedSensorPin,OUTPUT);
    VSSfreq = originalVSSfreq;
    SensorFreq = originalSensorFreq;
    tone(simulatedVSSpin,VSSfreq);
    
  }
  
  if (testStarted){
      if (currentMillis - startTime >= speedChangeStartTime){
        if (currentMillis - VSSfreqChangeTime >= VSStimeChangeStep){ //change this number to change delta-T
              VSSfreqChangeTime = currentMillis;
              if (VSSfreq > 31){
                VSSfreq -= VSSfreqChangeStep;  //change this number to change delta-VSSfreq
                tone(simulatedVSSpin,VSSfreq);
              }
              else {
                VSSfreq = 31; //Constrain for negative VSSfrequencies.
                pinMode(simulatedVSSpin,INPUT);
                digitalWrite(simulatedVSSpin,0);
              }
         }
      }
      else{
        VSSfreq = originalVSSfreq + modAmp*sin(2*modFreq*3.1415927*(currentMillis-startTime)/1000 );
        tone(simulatedVSSpin,VSSfreq); 
      }
    if (currentMillis - startTime >= powerLossStartTime && !powerOff){
       powerOff = true;
       digitalWrite(powerRelayPin, powerOff); //cut power
    }
    
    if (currentMillis - startTime >= powerLossStartTime + powerLossDuration && powerOff){
       powerOff = false;
       digitalWrite(powerRelayPin, powerOff); //Turn power back on
    }
    
    if (currentMillis - startTime >= faultRelayPinStartTime && !faultRelayPinOn){
       faultRelayPinOn = true;
       digitalWrite(faultRelayPin, faultRelayPinOn); //cut power
    }
    
    if (currentMillis - startTime >= faultRelayPinStartTime + faultRelayPinDuration && faultRelayPinOn){
       faultRelayPinOn = false;
       digitalWrite(faultRelayPin, faultRelayPinOn); //Turn power back on
    }
    
    if (currentMillis - startTime > testDuration){
      testStarted=false;
      //pinMode(simulatedVSSpin,OUTPUT);
      Serial.println("Test Stopped.");
      
    }
    
//    if (currentMillis - displayTime >= 100){
//      displayTime = currentMillis;
//      Serial.print(currentMillis-startTime);
//      Serial.print("\t");
//      Serial.print(VSSfreq);
//      Serial.print("\t");
//      Serial.print(appByte);
//      Serial.print("\t");
//      Serial.print(!powerOff);
//      Serial.print("\t");
//      Serial.println(!faultRelayPinOn);
//    }
  }
  else
  {
   
  }
  
  currentMillis = millis();
  appByte = originalPedalPeriod + pedalAmp*sin(2*pedFreq*3.1415927*(currentMillis-startTime)/1000);
  if (currentMillis - lastSensorChangeTime >= accelPedalPeriod){
    lastSensorChangeTime = currentMillis;
    acceleratorSerial.write(byte(appByte));
  }
 
}


